<?php
if (!defined('ABSPATH')) { exit; }

function smabai_rewrite($text){
    $syn = [ 'fast'=>'quick','optimize'=>'improve','great'=>'excellent','simple'=>'straightforward','use'=>'utilize','make'=>'create','help'=>'assist','show'=>'display','get'=>'obtain','big'=>'large','small'=>'compact','good'=>'solid','bad'=>'poor'];
    $out = $text;
    foreach ($syn as $a=>$b){ $out = preg_replace('/\b'.preg_quote($a,'/').'\b/i', $b, $out); }
    $sent = preg_split('/([\.!?])/',$out,-1,PREG_SPLIT_DELIM_CAPTURE);
    $chunks=[]; for($i=0;$i<count($sent)-1;$i+=2){ $chunks[] = trim($sent[$i].$sent[$i+1]); }
    if (count($chunks)>2) { shuffle($chunks); $out = implode(' ', $chunks); }
    return $out;
}

function smabai_detect_category_tags($content){
    $kws = smabai_keywords($content);
    $tags = array_slice($kws,0,10);
    $map = ['wordpress'=>'WordPress','plugin'=>'Plugins','security'=>'Security','speed'=>'Performance','seo'=>'SEO','image'=>'Media','database'=>'Database','cache'=>'Cache'];
    $cats=[]; foreach($map as $kw=>$cat){ if (in_array($kw,$kws,true)) $cats[] = $cat; }
    if (empty($cats)) $cats[] = 'Blog';
    return [$cats,$tags];
}