<?php
if (!defined('ABSPATH')) { exit; }

function smabai_generate_featured_image($title, $prompt=''){
    if (!function_exists('imagecreatetruecolor')) return 0;
    $w=1200; $h=630; $img = imagecreatetruecolor($w,$h);
    $bg = imagecolorallocate($img, 60, 80, 150);
    imagefilledrectangle($img,0,0,$w,$h,$bg);
    $fg = imagecolorallocate($img, 255,255,255);
    $font = 5; $lines = wordwrap($title, 28, "\n");
    $y = 50; foreach(explode("\n", $lines) as $line){ imagestring($img, $font, 40, $y, $line, $fg); $y += 20; }
    if ($prompt){ imagestring($img, 3, 40, $h-40, substr($prompt,0,60), $fg); }
    $upload = wp_upload_dir();
    $dir = trailingslashit($upload['basedir']) . 'sm-autoblogger';
    if (!is_dir($dir)) { wp_mkdir_p($dir); }
    $path = $dir . '/img-' . time() . '.png';
    imagepng($img, $path); imagedestroy($img);
    if (!is_file($path)) return 0;
    $filetype = wp_check_filetype(basename($path), null);
    $attachment = [ 'post_mime_type' => $filetype['type'], 'post_title' => sanitize_file_name(basename($path)), 'post_content' => '', 'post_status' => 'inherit' ];
    $attach_id = wp_insert_attachment($attachment, $path);
    require_once ABSPATH . 'wp-admin/includes/image.php';
    $attach_data = wp_generate_attachment_metadata($attach_id, $path);
    wp_update_attachment_metadata($attach_id, $attach_data);
    return $attach_id;
}