<?php
if (!defined('ABSPATH')) { exit; }

function smabai_clean_text($html){ $t = wp_strip_all_tags($html); $t = preg_replace('/\s+/',' ', $t); return trim($t); }
function smabai_flesch($content){ $text = smabai_clean_text($content); $sent = max(1, count(preg_split('/[\.!?]+/',$text,-1,PREG_SPLIT_NO_EMPTY))); $words = max(1, count(preg_split('/\s+/', $text))); $sy = 0; foreach (preg_split('/\s+/', $text) as $w){ $sy += smabai_syllables($w); } $score = 206.835 - (1.015*($words/$sent)) - (84.6*($sy/$words)); return round($score,2); }
function smabai_syllables($w){ $w = strtolower(preg_replace('/[^a-z]/','',$w)); if ($w==='') return 0; $w = preg_replace('/e$/','',$w); $g = preg_match_all('/[aeiouy]+/',$w); return max(1,(int)$g); }
function smabai_quality_score($content){ $len = strlen(smabai_clean_text($content)); $read = smabai_flesch($content); $score = 0; if ($len>=600) $score+=30; elseif ($len>=300) $score+=20; elseif ($len>=150) $score+=10; if ($read>=60) $score+=30; elseif ($read>=40) $score+=20; $kw = count(smabai_keywords($content)); if ($kw>=8) $score+=20; elseif ($kw>=4) $score+=10; $score+=20; return min(100,$score); }
function smabai_keywords($content){ $text = strtolower(wp_strip_all_tags($content)); $text = preg_replace('/[^a-z0-9\s]/',' ', $text); $words = preg_split('/\s+/', $text, -1, PREG_SPLIT_NO_EMPTY); $stop = ['the','a','an','and','or','of','to','in','on','for','with','at','by','is','it','this','that','from','as','be']; $freq=[]; foreach($words as $w){ if (strlen($w)<3 || in_array($w,$stop,true)) continue; $freq[$w]=($freq[$w]??0)+1; } arsort($freq); return array_slice(array_keys($freq),0,20); }
function smabai_is_duplicate($title,$content){ $hash = md5(strtolower($title.'|'.smabai_clean_text($content))); $seen = get_option('smabai_hashes', []); if (isset($seen[$hash])) return true; $seen[$hash]=time(); if (count($seen)>1000) { $seen = array_slice($seen,-1000,true); } update_option('smabai_hashes',$seen); return false; }