<?php
/*
Plugin Name: SM AutoBlogger AI
Plugin URI: https://smarttoolhub.digital/
Description: Auto-posting from RSS/URLs with keyword filters, local AI rewrite, auto image generation, categories/tags detection, duplicate check, quality scoring, and scheduling.
Version: 1.0.0
Author: SmartToolHub
Author URI: https://smarttoolhub.digital/
License: GPLv2 or later
Text Domain: sm-autoblogger-ai
*/

if (!defined('ABSPATH')) { exit; }

define('SMABAI_VER', '1.0.0');
define('SMABAI_FILE', __FILE__);
define('SMABAI_DIR', plugin_dir_path(__FILE__));

require_once SMABAI_DIR . 'includes/util.php';
require_once SMABAI_DIR . 'includes/ai.php';
require_once SMABAI_DIR . 'includes/rss.php';
require_once SMABAI_DIR . 'includes/image.php';
require_once SMABAI_DIR . 'includes/cron.php';

function smabai_render_feed_row($i, $f){
    $u = esc_attr($f['url'] ?? '');
    $k = esc_attr($f['keywords'] ?? '');
    $ap = !empty($f['auto_publish']);
    $rw = !empty($f['rewrite']);
    $ip = esc_attr($f['image_prompt'] ?? '');
    return '<div class="smabai-row" style="padding:8px;border:1px solid #eee;margin-bottom:8px;">'
    . '<input type="text" name="smabai_feeds['.$i.'][url]" value="'.$u.'" placeholder="Feed URL" class="regular-text" /> '
    . '<input type="text" name="smabai_feeds['.$i.'][keywords]" value="'.$k.'" placeholder="Keywords (comma-separated)" class="regular-text" /> '
    . '<label><input type="checkbox" name="smabai_feeds['.$i.'][auto_publish]" '.($ap?'checked':'').' /> Auto Publish</label> '
    . '<label><input type="checkbox" name="smabai_feeds['.$i.'][rewrite]" '.($rw?'checked':'').' /> Rewrite</label> '
    . '<input type="text" name="smabai_feeds['.$i.'][image_prompt]" value="'.$ip.'" placeholder="Image prompt" class="regular-text" />'
    . '</div>';
}

add_action('admin_menu', function(){
    add_menu_page('SM AutoBlogger', 'SM AutoBlogger', 'manage_options', 'sm-autoblogger', function(){
        if (!current_user_can('manage_options')) return;
        if (isset($_POST['smabai_save']) && check_admin_referer('smabai_save')) {
            $feeds = [];
            $raw = isset($_POST['smabai_feeds']) ? (array)$_POST['smabai_feeds'] : [];
            foreach ($raw as $r) {
                $f = [
                    'url' => sanitize_text_field($r['url'] ?? ''),
                    'keywords' => sanitize_text_field($r['keywords'] ?? ''),
                    'auto_publish' => isset($r['auto_publish']) ? '1' : '0',
                    'rewrite' => isset($r['rewrite']) ? '1' : '0',
                    'image_prompt' => sanitize_text_field($r['image_prompt'] ?? ''),
                ];
                if ($f['url'] !== '') { $feeds[] = $f; }
            }
            update_option('smabai_feeds', $feeds);
            update_option('smabai_schedule', sanitize_text_field($_POST['smabai_schedule'] ?? 'hourly'));
            echo '<div class="notice notice-success"><p>Settings saved.</p></div>';
        }
        $feeds = get_option('smabai_feeds', []);
        $schedule = get_option('smabai_schedule','hourly');
        echo '<div class="wrap"><h1>SM AutoBlogger AI</h1><form method="post">';
        wp_nonce_field('smabai_save');
        echo '<h2>Feeds</h2><div id="smabai-feeds">';
        $idx = 0; foreach ($feeds as $f) { echo smabai_render_feed_row($idx++, $f); }
        echo smabai_render_feed_row($idx, ['url'=>'','keywords'=>'','auto_publish'=>'1','rewrite'=>'1','image_prompt'=>'']);
        echo '</div>';
        echo '<p><button class="button" type="button" onclick="smabaiAddRow()">Add Feed</button></p>';
        echo '<h2>Schedule</h2><select name="smabai_schedule">';
        foreach (['hourly'=>'Hourly','twicedaily'=>'Twice Daily','daily'=>'Daily'] as $k=>$v) { echo '<option value="' . esc_attr($k) . '" ' . selected($schedule,$k,false) . '>' . esc_html($v) . '</option>'; }
        echo '</select>';
        echo '<p><button class="button button-primary" name="smabai_save" value="1">Save</button></p></form>';
        echo '<h2>Bulk Import (CSV URLs)</h2><form method="post"><textarea name="smabai_csv" class="large-text" rows="5"></textarea>'; wp_nonce_field('smabai_bulk'); echo '<p><button class="button" name="smabai_do_bulk" value="1">Import</button></p></form>';
        if (isset($_POST['smabai_do_bulk']) && check_admin_referer('smabai_bulk')) {
            $csv = (string)($_POST['smabai_csv'] ?? '');
            $urls = array_filter(array_map('trim', preg_split('/\r?\n/', $csv)));
            $count = 0;
            foreach ($urls as $u) { $ok = smabai_import_url($u, ['rewrite'=>true]); if ($ok) $count++; }
            echo '<div class="notice notice-success"><p>Imported ' . esc_html($count) . ' URLs.</p></div>';
        }
        echo '<script>function smabaiAddRow(){var c=document.getElementById("smabai-feeds");var i=c.querySelectorAll(".smabai-row").length;var h=\'' . str_replace("'","\'", smabai_render_feed_row('__IDX__', ['url'=>'','keywords'=>'','auto_publish'=>'1','rewrite'=>'1','image_prompt'=>''])) . '\';h=h.replace(/__IDX__/g,i);c.insertAdjacentHTML("beforeend",h);}</script>';
        echo '</div>';
    }, 'dashicons-rss', 88);
});