<?php
if (!defined('ABSPATH')) { exit; }

add_action('login_form', function(){
    $site = get_option('smssl_recaptcha_site','');
    if ($site) { echo '<div style="margin:10px 0;" class="g-recaptcha" data-sitekey="' . esc_attr($site) . '"></div><script src="https://www.google.com/recaptcha/api.js" async defer></script>'; }
});

add_filter('authenticate', function($user, $username, $password){
    $ip = smssl_get_ip();
    $limit = (int)get_option('smssl_limit_attempts', 5);
    $data = get_option('smssl_attempts', []);
    $now = time();
    $row = $data[$ip] ?? ['count'=>0,'ts'=>$now];
    if (($now - $row['ts']) > 900) { $row = ['count'=>0,'ts'=>$now]; }
    if ($row['count'] >= $limit) { smssl_alert('Brute force blocked', 'IP ' . $ip . ' blocked after login attempts'); return new WP_Error('blocked', __('Too many login attempts. Try later.')); }
    $site = get_option('smssl_recaptcha_site','');
    $secret = get_option('smssl_recaptcha_secret','');
    if ($site && $secret) {
        $resp = wp_remote_post('https://www.google.com/recaptcha/api/siteverify', ['body'=>['secret'=>$secret,'response'=>($_POST['g-recaptcha-response'] ?? ''),'remoteip'=>$ip],'timeout'=>5]);
        $ok = (!is_wp_error($resp)) ? json_decode(wp_remote_retrieve_body($resp), true) : ['success'=>false];
        if (empty($ok['success'])) { return new WP_Error('captcha', __('reCAPTCHA failed.')); }
    }
    if (is_wp_error($user)) { $row['count']++; $data[$ip] = $row; update_option('smssl_attempts', $data); } else { $row = ['count'=>0,'ts'=>$now]; $data[$ip] = $row; update_option('smssl_attempts', $data); }
    return $user;
}, 30, 3);