<?php
if (!defined('ABSPATH')) { exit; }

function smssl_get_ip() {
    foreach (['HTTP_CF_CONNECTING_IP','HTTP_X_FORWARDED_FOR','HTTP_X_REAL_IP','REMOTE_ADDR'] as $k) {
        if (!empty($_SERVER[$k])) { $v = explode(',', $_SERVER[$k])[0]; return trim($v); }
    }
    return '0.0.0.0';
}

function smssl_log_event($type, $data = []) {
    $logs = get_option('smssl_logs', []);
    $logs[] = ['time'=>time(),'type'=>$type,'data'=>$data];
    if (count($logs) > 200) { $logs = array_slice($logs, -200); }
    update_option('smssl_logs', $logs);
}

function smssl_alert($subject, $message) {
    $admin = get_option('admin_email');
    wp_mail($admin, $subject, $message);
    smssl_log_event('alert', ['subject'=>$subject]);
}

function smssl_render_alerts() {
    $logs = array_reverse(get_option('smssl_logs', []));
    echo '<ul>'; foreach (array_slice($logs,0,20) as $l) { echo '<li>' . esc_html(date('d M Y H:i',$l['time'])) . ' — ' . esc_html($l['type']) . '</li>'; } echo '</ul>';
}

function smssl_get_status_summary() {
    return [
        'firewall' => get_option('smssl_htaccess_hardening','0')==='1' ? 'On' : 'Soft',
        'login' => 'Enabled',
        'last_scan' => date('d M Y H:i', (int)get_option('smssl_last_scan', 0))
    ];
}

function smssl_apply_htaccess() {
    $hard = get_option('smssl_htaccess_hardening','0');
    if ($hard !== '1') return;
    $path = ABSPATH . '.htaccess';
    $rules = "\n# SM SecureShield Lite\n<Files xmlrpc.php>\nOrder allow,deny\nDeny from all\n</Files>\n";
    if (file_exists($path)) {
        $cur = file_get_contents($path);
        if (strpos($cur, '# SM SecureShield Lite') === false) { file_put_contents($path, $cur . $rules); }
    }
}