<?php
/*
Plugin Name: SM SecureShield Lite
Plugin URI: https://smarttoolhub.digital/
Description: Security plugin with firewall, login protections, scanners, backups, alerts, and hardening.
Version: 1.0.0
Author: SmartToolHub
Author URI: https://smarttoolhub.digital/
License: GPLv2 or later
Text Domain: sm-secureshield-lite
*/

if (!defined('ABSPATH')) { exit; }

define('SMSSL_VER', '1.0.0');
define('SMSSL_FILE', __FILE__);
define('SMSSL_DIR', plugin_dir_path(__FILE__));
define('SMSSL_URL', plugins_url('', __FILE__));

require_once SMSSL_DIR . 'includes/utils.php';
require_once SMSSL_DIR . 'includes/firewall.php';
require_once SMSSL_DIR . 'includes/login.php';
require_once SMSSL_DIR . 'includes/scanner.php';
require_once SMSSL_DIR . 'includes/backup.php';

add_action('admin_menu', function(){
    add_menu_page('SM Secure', 'SM Secure', 'manage_options', 'sm-secure', function(){
        if (!current_user_can('manage_options')) { return; }
        $nonce = wp_create_nonce('smssl_action');
        $status = smssl_get_status_summary();
        echo '<div class="wrap"><h1>SM SecureShield Lite</h1>';
        echo '<p><strong>Firewall:</strong> ' . esc_html($status['firewall']) . '</p>';
        echo '<p><strong>Login Protections:</strong> ' . esc_html($status['login']) . '</p>';
        echo '<p><strong>Last Scan:</strong> ' . esc_html($status['last_scan']) . '</p>';
        echo '<form method="post"><input type="hidden" name="_wpnonce" value="' . esc_attr($nonce) . '" />';
        echo '<button class="button button-primary" name="smssl_do" value="scan">Run Security Scan</button> ';
        echo '<button class="button" name="smssl_do" value="backup">Run Backup</button></form>';
        if (isset($_POST['smssl_do']) && wp_verify_nonce($_POST['_wpnonce'] ?? '', 'smssl_action')) {
            if ($_POST['smssl_do'] === 'scan') { $rep = smssl_run_full_scan(); smssl_render_report($rep); }
            if ($_POST['smssl_do'] === 'backup') { $path = smssl_run_backup(); echo '<p>Backup: ' . esc_html($path) . '</p>'; }
        }
        echo '<h2>Recent Alerts</h2>'; smssl_render_alerts();
        echo '</div>';
    }, 'dashicons-shield', 86);
    add_submenu_page('sm-secure', 'Settings', 'Settings', 'manage_options', 'sm-secure-settings', function(){
        if (!current_user_can('manage_options')) { return; }
        if (isset($_POST['smssl_save']) && check_admin_referer('smssl_save')) {
            update_option('smssl_recaptcha_site', sanitize_text_field($_POST['smssl_recaptcha_site'] ?? ''));
            update_option('smssl_recaptcha_secret', sanitize_text_field($_POST['smssl_recaptcha_secret'] ?? ''));
            update_option('smssl_limit_attempts', (int)($_POST['smssl_limit_attempts'] ?? 5));
            update_option('smssl_htaccess_hardening', isset($_POST['smssl_htaccess_hardening']) ? '1' : '0');
            update_option('smssl_disable_xmlrpc', isset($_POST['smssl_disable_xmlrpc']) ? '1' : '0');
            echo '<div class="notice notice-success"><p>Settings saved.</p></div>';
            smssl_apply_htaccess();
        }
        $site = get_option('smssl_recaptcha_site', '');
        $secret = get_option('smssl_recaptcha_secret', '');
        $limit = (int)get_option('smssl_limit_attempts', 5);
        $hard = get_option('smssl_htaccess_hardening', '0');
        $xmlrpc = get_option('smssl_disable_xmlrpc', '0');
        echo '<div class="wrap"><h1>SM Secure Settings</h1><form method="post">';
        wp_nonce_field('smssl_save');
        echo '<table class="form-table">';
        echo '<tr><th>reCAPTCHA Site Key</th><td><input type="text" name="smssl_recaptcha_site" value="' . esc_attr($site) . '" class="regular-text"/></td></tr>';
        echo '<tr><th>reCAPTCHA Secret Key</th><td><input type="text" name="smssl_recaptcha_secret" value="' . esc_attr($secret) . '" class="regular-text"/></td></tr>';
        echo '<tr><th>Limit Login Attempts</th><td><input type="number" name="smssl_limit_attempts" value="' . esc_attr($limit) . '" min="3" max="20"/></td></tr>';
        echo '<tr><th>.htaccess Hardening</th><td><label><input type="checkbox" name="smssl_htaccess_hardening" ' . checked('1', $hard, false) . ' /> Enable</label></td></tr>';
        echo '<tr><th>Disable XML-RPC</th><td><label><input type="checkbox" name="smssl_disable_xmlrpc" ' . checked('1', $xmlrpc, false) . ' /> Disable</label></td></tr>';
        echo '</table><p><button class="button button-primary" name="smssl_save" value="1">Save Settings</button></p></form></div>';
    });
});

add_action('init', function(){ smssl_firewall_boot(); });
add_filter('xmlrpc_enabled', function($enabled){ return get_option('smssl_disable_xmlrpc','0')==='1' ? false : $enabled; });
add_action('wp_login', function($user_login){ smssl_log_event('login', ['user'=>$user_login]); });
add_action('wp_logout', function(){ smssl_log_event('logout', ['user'=>wp_get_current_user()->user_login ?? '']); });

register_activation_hook(SMSSL_FILE, function(){ smssl_apply_htaccess(); });