<?php
if (!defined('ABSPATH')) { exit; }

add_filter('the_content', function($content){
    if (get_option('smspb_lazy','0')==='1') { $content = preg_replace('/<img\b(?![^>]*loading=)/i', '<img loading="lazy" ', $content); }
    if (get_option('smspb_webp','0')==='1') {
        $content = preg_replace_callback('/<img\b[^>]*src=\"([^\"]+)\"[^>]*>/i', function($m){
            $src = html_entity_decode($m[1]);
            $file = str_replace(site_url('/'), ABSPATH, $src);
            if (is_file($file)) { $webp = smspb_to_webp($file); if ($webp) { $new = str_replace($src, str_replace(ABSPATH, site_url('/'), $webp), $m[0]); return $new; } }
            return $m[0];
        }, $content);
    }
    return $content;
});

add_filter('script_loader_tag', function($tag, $handle, $src){
    if (get_option('smspb_defer_js','0')==='1' && strpos($tag, ' defer') === false) { $tag = str_replace('<script ', '<script defer ', $tag); }
    return $tag;
}, 10, 3);

add_action('wp_print_scripts', function(){
    if (!is_singular()) return;
    global $post; if (!$post) return;
    $val = get_post_meta($post->ID, '_smspb_remove_scripts', true);
    if ($val) {
        $handles = array_filter(array_map('trim', explode(',', $val)));
        foreach ($handles as $h) { wp_dequeue_script($h); wp_deregister_script($h); }
    }
});